<?php
/**
* @package direct-as-a-service
* @subpackage views
 * @filesource
*/ /** */

	$this->load->view('api/header'); 
	$this->load->view('api/nav'); 
?>
				<h1><a href="/onboarding/documentation/" class="underline">Documentation</a> &rarr; <a class="underline" href="/onboarding/send">/direct/send</a> - POST</h1>
				<p>The send web service allows authorized applications to send messages using the Direct standards and can be accessed by sending a POST request to /direct/send. Below are some code examples for sending a message using the send web service.</p>
				<h3>Java</h3>
				<p>
					<?php 
			require_once '/application/third_party/luminous/luminous.php'; 
			echo luminous::highlight('java', 'import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Map;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
 
public class VLERDirectTest {
    private boolean validate(String address, Properties props) {
        boolean rtc = false;
        HttpURLConnection conn = null;
      
        try {
            String encaddress = new sun.misc.BASE64Encoder().encode(address.getBytes());
            URL url = new URL(((String)props.get("vler.validateurl")) + "?address=" + encaddress);
            conn = (HttpURLConnection)url.openConnection();
            java.util.Date dt = new java.util.Date();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
            String dstr = sdf.format(dt);
            String reqstr = "GET\n" + dstr + "\n" + ((String)props.get("vler.validatepath")) + "?address=" + encaddress;
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(((String)props.get("vler.privatekey")).getBytes(),"HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] sha = sha256_HMAC.doFinal(reqstr.getBytes());
            String encsha = new sun.misc.BASE64Encoder().encode(sha);
            String auth = "DAAS " + ((String)props.get("vler.publickey")) + ":" + encsha;
            conn.setRequestProperty("Authorization", auth);
            conn.setRequestProperty("Date", dstr);
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestMethod("GET");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + conn.getResponseCode());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
            String output;
            String resp = "";
            while ((output = br.readLine()) != null) {
                resp += output;
            }
            if (resp.indexOf("\"valid\":true") >= 0) {
                  rtc = true;
            }
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rtc;
    }
    private boolean send(String sender, String to, String cc, String mailtype, String priority, String subject, String body, String[] files, Properties props) {
        boolean rtc = false;
        HttpURLConnection conn = null;
      
        try {
            URL url = new URL(((String)props.get("vler.sendurl")));
            conn = (HttpURLConnection)url.openConnection();
            java.util.Date dt = new java.util.Date();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
            String dstr = sdf.format(dt);
            String reqstr = "POST\n" + dstr + "\n" + ((String)props.get("vler.sendpath"));
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(((String)props.get("vler.privatekey")).getBytes(),"HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] sha = sha256_HMAC.doFinal(reqstr.getBytes());
            String encsha = new sun.misc.BASE64Encoder().encode(sha);
            String auth = "DAAS " + ((String)props.get("vler.publickey")) + ":" + encsha;
            conn.setRequestProperty("Authorization", auth);
            conn.setRequestProperty("Date", dstr);
            String charset = "UTF-8";
            String boundary = Long.toString(System.currentTimeMillis(), 16);
            String lineEnd = "\r\n";
            String twoHyphens = "--";
            String uploadFile = "c32input.xml";
           
            // Allow Inputs
            conn.setDoInput(true);
 
            // Allow Outputs
            conn.setDoOutput(true);
 
            // Don\'t use a cached copy.
            conn.setUseCaches(false);
 
            // Use a post method.
            conn.setRequestMethod("POST");
            
            conn.setRequestProperty("Connection", "Keep-Alive");
            conn.setRequestProperty("Accept-Charset", charset);
            conn.setRequestProperty("Charset", charset);
            conn.setRequestProperty("ENCTYPE", "multipart/form-data");
            conn.setRequestProperty("Cache-Control", "no-cache");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary); //boundary was misspelled here as boundry
           
            DataOutputStream ds = new DataOutputStream(conn.getOutputStream());
           
       		//put plain text post data into an array so we can build the raw request
            Map<String, String> post_fields = new HashMap<String, String>();
            post_fields.put("sender",sender);
            post_fields.put("to",to);
            if (cc != null && cc.length() > 0) {post_fields.put("cc",cc); }
            if (subject != null && subject.length() > 0) { post_fields.put("subject",subject); }
            if (body != null && body.length() > 0) { post_fields.put("body",body); }
            if (mailtype != null && mailtype.length() > 0) { post_fields.put("mailtype",mailtype); }
            if (priority != null && priority.length() > 0) { post_fields.put("priority",priority); }
            
			//setRequestProperty seems to set headers for the overall request, but the POST body comes after those
            //so loop through normal POST fields and add to raw request body instead
            for(Map.Entry<String, String> entry : post_fields.entrySet()) {
            	ds.writeBytes(twoHyphens + boundary + lineEnd);
            	ds.writeBytes("Content-Disposition: form-data; name=\""+entry.getKey()+"\"" + lineEnd + lineEnd + entry.getValue() + lineEnd);
            }
                 
            //if you have more than one file you\'d loop through them here, but let\'s just use your one example file for now
            ds.writeBytes(twoHyphens + boundary + lineEnd);
            ds.writeBytes("Content-Disposition: form-data; name=\"files\";filename=\"" + uploadFile +"\"" + lineEnd);
            //added generic content type for the file and specified transfer encoding, this appears to be necessary for files
            ds.writeBytes("Content-Type: application/octet-stream" + lineEnd);
            ds.writeBytes("Content-Transfer-Encoding: binary" + lineEnd);
            ds.writeBytes(lineEnd);
 			
            FileInputStream fStream = new FileInputStream(uploadFile);
            int bufferSize = 1024;
            byte[] buffer = new byte[bufferSize];
            int length = -1;
 
            while((length = fStream.read(buffer)) != -1) {
              ds.write(buffer, 0, length);
            }
            ds.writeBytes(lineEnd);
            ds.writeBytes(twoHyphens + boundary + twoHyphens + lineEnd);
            /* close streams */
			
            fStream.close();
            ds.flush();
            ds.close();
			//conn.connect();
           
           	//added the response message on failure as well, because it can help with debugging potentially
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("\nFailed : HTTP error code : " + conn.getResponseCode() + "\nHTTP response : " + conn.getResponseMessage());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader((conn.getInputStream())));
            String output;
            String resp = "";
            while ((output = br.readLine()) != null) {
                resp += output;
            }
			System.err.println("resp = " + resp);
            if (resp.indexOf("\"message\":\"Message sent.\"") >= 0) { //for a successful send, you should get a messsage field saying Message sent
                  rtc = true;
            }
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rtc;
    }
   
    public static void main(String[] args) {
        VLERDirectTest test = new VLERDirectTest();
        Properties props = System.getProperties();
        props.put("vler.publickey", "8f5f968d19047f8d8614338d7e10b550022f858d49215195e6320640c31b42eb");
        props.put("vler.privatekey", "acbb607d9ca14d16ba5e916b1acc92b6995848690b0ea6c0ad375f59298b8a56");
        props.put("vler.validateurl", "https://api.demo.careinbox.com/direct/validate/format/json");
        props.put("vler.validatepath","/direct/validate/format/json");
        props.put("vler.sendurl", "https://api.demo.careinbox.com/direct/send/format/json");
        props.put("vler.sendpath","multipart/form-data\n/direct/send/format/json");
       
        System.out.println("swilliams@example.com: " + test.validate("swilliams@example.com", props));
        System.out.println("swilliams@demo.careinbox.com: " + test.validate("swilliams@demo.careinbox.com", props));
        System.out.println("abell2@demo.careinbox.com: " + test.validate("abell2@demo.careinbox.com", props));
        System.out.println("send abell2@demo.careinbox.com: " + test.send("abell2@demo.careinbox.com", "abell2@demo.careinbox.com", "", "", "", "Test subject", "Test body", null, props));
     }
}
', false);
		?>
				</p>
				<h3>HTML and JavaScript</h3>
				<p>
					<?php 
						echo luminous::highlight('php', '<html>
	<head>
		<title><?PHP echo $title; ?></title>
		<LINK href="/css/example.css" rel="stylesheet" type="text/css">
		<link rel="stylesheet" type="text/css" href="/css/custom-theme/jquery-ui-1.8.18.custom.css" />
		<script type="text/javascript" src="/js/jquery.min.js"></script>
		<script type="text/javascript" src="/js/jquery-ui-1.8.17.custom.min.js"></script>
		<script type="text/javascript" src="/js/jquery.form.js"></script>
		<script type="text/javascript" src="/js/rollups/hmac-sha256.js"></script>
		<script type="text/javascript" src="/js/components/enc-base64-min.js"></script>
		<script type="text/javascript" src="/js/date.format.js"></script>
		<script type="text/javascript">
			var messagesSent = 0;

			var attachments = 0;

			var attempts = 0;

			var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

			var start = new Date().getTime();
			var end = new Date().getTime();

			function encode64(input) {
			   if (!String(input).length) return false;
			   var output = "";
			   var chr1, chr2, chr3;
			   var enc1, enc2, enc3, enc4;
			   var i = 0;

			   do {
			      chr1 = input.charCodeAt(i++);
			      chr2 = input.charCodeAt(i++);
			      chr3 = input.charCodeAt(i++);

			      enc1 = chr1 >> 2;
			      enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
			      enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
			      enc4 = chr3 & 63;

			      if (isNaN(chr2)) {
			         enc3 = enc4 = 64;
			      } else if (isNaN(chr3)) {
			         enc4 = 64;
			      }

			      output = output + keyStr.charAt(enc1) + keyStr.charAt(enc2) + 
			         keyStr.charAt(enc3) + keyStr.charAt(enc4);
			   } while (i < input.length);
			   
			   return output;
			}

			function addRow() {
				attachments++;
				var refnode = $(\'#attach_div\');
				var attach = $(\'<div class="add_attach"><label>File:</label> <input class="attachmentItem" type="file" class="attachment" name="attachment\'+attachments+\'" id="attachment\'+attachments+\'"/><a href="#" onClick="$(this).parent().remove();">Remove</a></div>\');
				attach.insertBefore(refnode);
			};
			
			$(function() {
				$(".json").click(function() {
					$("#sender").css("background-color","#fff");
					$("#to").css("background-color","#fff");
					$("#messageForm").ajaxSubmit({  
					  type: "POST",  
					  url: "/direct/send/format/json",  
					  beforeSend: function(request){
						start = new Date().getTime();
						//use this block if you want to send UTC stamp
						/*var d = Date.now();
						var currentDate = Math.round(d / 1000);*/
						//use this block if you want to send normal timestamp with timezone
						var d = new Date();
						var currentDate = d.format("mm/dd/yyyy HH:MM:ss Z");
					
						var hashString = CryptoJS.HmacSHA256("POST\n"+currentDate+"\nmultipart/form-data\n/direct/send/format/json","947d0e7ada02a75f2643fa409f19e976b235db5e86b93b292697d980ba177206");
						var base64 = encode64(""+hashString);
						var authorization = "DAAS 323716a85b68f3f1ef7595900c00f5d6e395fad9e88537589a43a688904c511e:"+base64;
						request.setRequestHeader("Authorization", authorization);
						request.setRequestHeader("X-Daas-Date", currentDate);
						attempts++;
						var appendStr = "<div class=\"innerPost break-word\" id=\"post"+attempts+"\">"+
												"<div class=\"inner\"><label>"+attempts+".</label></div>"+
												"<div class=\"inner\"><label>Custom Request Headers</label></div>"+
												"<div class=\"inner indent\"><label>Authentication: </label>"+authorization+"</div>"+
												"<div class=\"inner indent\"><label>DaasDate: </label>"+currentDate+"</div>"+
												"<div class=\"inner\"><label>Content</label></div>"+
												"<div class=\"inner indent\"><label>Mailtype: </label>"+$(\'#mailtype\').val()+"</div>"+
												"<div class=\"inner indent\"><label>Priority: </label>"+$(\'#priority\').val()+"</div>"+
												"<div class=\"inner indent\"><label>To: </label>"+$(\'#to\').val()+"</div>"+
												"<div class=\"inner indent\"><label>Sender: </label>"+$(\'#sender\').val()+"</div>"+
												"<div class=\"inner indent\"><label>Subject: </label>"+$(\'#subject\').val()+"</div>"+
												"<div class=\"inner indent\"><label>Body: </label>"+$(\'#body\').val()+"</div>"+
												"<div class=\"inner\"><label>Files</label></div>";
						$(\'.attachmentItem\').each(function(){
							if ($(this).val()){
								appendStr += "<div class=\"inner indent\"><label>"+$(this).attr(\'name\')+": </label>"+$(this).val().mb_split(\'\\\').pop()+"</div>";
							}
						});
						appendStr += "</div>";
						$(\'#postWrapper\').append(appendStr);
					  },
					  success: function(data, status, jqXHR) { 
						$(\'#success\').html(data[\'message\']).slideDown(500).delay(10000).slideUp(500);
						end = new Date().getTime();
						$(\'#responseWrapper\').append("<div class=\"inner break-word\"><label>"+attempts+". "+status+" - </label>"+jqXHR.responseText + ", Execution time: "+(end - start)+" ms</div>");
						$(\'#post\'+attempts).css("background", "#E0FFD6");
						$(\'#post\'+attempts).css("border", "1px solid #008A1A");
						$(\'.add_attach\').remove();
						$(\'#messageForm\')[0].reset();
						attachments = 0;
						messagesSent++;
					  },
					  error: function (jqXHR, textStatus, errorThrown) {
						end = new Date().getTime();
						$(\'#error\').html(\'<div class="imageText">\' + $.parseJSON(jqXHR.responseText)[\'message\'] + \'</div>\').slideDown(500).delay(10000).slideUp(500);
						$(\'#responseWrapper\').append("<div class=\"inner\"><label>"+attempts+". "+textStatus+" - </label>"+jqXHR.responseText+", Execution time: "+(end - start)+" ms</div>");
						$(\'#post\'+attempts).css("background", "#fef1ec");
						$(\'#post\'+attempts).css("border", "1px solid #990000");
						for (var i = 0; i < $.parseJSON(jqXHR.responseText)[\'fields\'].length; i++){
							$(\'#\'+$.parseJSON(jqXHR.responseText)[\'fields\'][i]).css("background-color", "#fef1ec");
						}
					  }
					});
				});
			});
		</script>
	</head>
	<body>
		<div class="container">
			<h1>Direct Mail</h1>
			<div id="success">Message sent!</div>
			<div id="error">Message failed!</div>
			<div class="wrapper">
				<form enctype="multipart/form-data" id="messageForm" action="/direct/send" method="POST">
					<label>Mailtype:</label> <select name="mailtype" id="mailtype">
												<option value="HTML">HTML</option>
												<option value="TEXT">Text</option>
											 </select> 
					<label class="left-spacing">Priority:</label> <select name="priority" id="priority">
																	<option value="5">Low</option>
																	<option value="3" SELECTED>Medium</option>
																	<option value="1">High</option>
																   </select><br/>
					<label>Sender:</label> <input type="text" name="sender" id="sender"> <label class="left-spacing">To:</label> <input type="text" name="to" id="to"><br/>
					<label>Subject:</label> <input type="text" class="full" name="subject" id="subject"><br/>
					<label>Body:</label> <textarea name="body" id="body"></textarea><br/>
					<div class="attachment"><label>File:</label> <input class="attachmentItem" type="file" name="attachment0" id="attachment0"/></div>
					<div id="attach_div"><label>&nbsp;</label><a href="#" onclick="javascript:addRow();">Add additional file</a></div>
				</form>
			</div>
			<div class="button-container"><input type="button" class="button json" value="Send"></div>
		</div>
		<br/><br/>
		<div id="post" class="message-container">
			<h1>Post Request</h1>
			<div id="postWrapper" class="wrapper">
			
			</div>
		</div>
		<br/><br/>
		<div id="response" class="message-container">
			<h1>Response Messages</h1>
			<div id="responseWrapper" class="wrapper">
			
			</div>
		</div>
	</body>
</html>', false);
					?>
				</p>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>